/**
 * \file: exchnd_interface.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * Header for the user space interface to the exception handler device.
 *
 * \component: exchndd
 *
 * \author: Kai Tomerius (ktomerius@de.adit-jv.com)
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef __EXCHND_INTERFACE_H__
#define __EXCHND_INTERFACE_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

/* Align with the driver version we are built against.
 * Change in API implies major version increase. Minor version shall
 * not affect the daemon.
 */
#define EXCHND_REQUIRED_VERSION_MIN (EXCHND_VERSION & 0xFF00)
#define EXCHND_REQUIRED_VERSION_MAX ((EXCHND_VERSION & 0xFF00) + 0x99)

enum EXH_ATTACHED_STATE {
    EXH_DETACHED,
    EXH_THREAD,
    EXH_PARTIAL_GROUP,
    EXH_GROUP
};

#define is_tracee_attached(x) ((x == EXH_THREAD) || (x == EXH_GROUP))

/* Interface to exception handler daemon */
typedef struct ExchndInterface {
    char *name;
    int efd;
    unsigned int PTRACE_attached;
} ExchndInterface_t;

/* exchnd_create - initialize the exception handler interface */
ExchndInterface_t *exchnd_create(const char *dev_name);

/* exchnd_info - information about the exception handler */
void exchnd_info(ExchndInterface_t *exh_if, int fd);

/* exchnd_get_version - retrieve the driver version */
unsigned long exchnd_get_version(ExchndInterface_t *exh_if);

/* exchnd_process - process the data from /dev/exchnd */
int exchnd_process(ExchndInterface_t *exh_if);

/* exchnd_destroy - de-initialize the error memory interface */
void exchnd_destroy(ExchndInterface_t *exh_if);
#endif /* ifndef __EXCHND_INTERFACE_H__ */